<?php
use App\Util;
use App\Router;
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Reception</h3>
    <div class="muted">Day: <?= Util::h($day['day_date']) ?> — Issue tickets, set prices, close day.</div>
  </div>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-light" href="<?= Router::url('/display') ?>" target="_blank">Display</a>
    <?php if (\App\Auth::is(['admin'])): ?>
      <a class="btn btn-outline-light" href="<?= Router::url('/admin') ?>">Admin</a>
    <?php endif; ?>
  </div>
</div>

<?php if (!empty($msg)): ?><div class="alert alert-success"><?= Util::h($msg) ?></div><?php endif; ?>
<?php if (!empty($err)): ?><div class="alert alert-danger"><?= Util::h($err) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-3">
      <h5 class="fw-bold">Issue Ticket</h5>
      <form method="post">
        <input type="hidden" name="action" value="issue">
        <div class="mb-2">
          <label class="form-label">Employee</label>
          <select class="form-select" name="employee_id" required>
            <option value="">Select...</option>
            <?php foreach ($employees as $e): ?>
              <option value="<?= (int)$e['id'] ?>"><?= Util::h($e['code'] . ' - ' . $e['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="mb-2">
          <label class="form-label">Customer Phone (WhatsApp)</label>
          <input class="form-control" name="phone" placeholder="+9689xxxxxxx">
        </div>
        <button class="btn btn-primary w-100">Issue & Print</button>
      </form>
      <div class="muted small mt-2">Printing opens a new tab. Configure the POS printer from the browser.</div>
    </div>

    <div class="card p-3 mt-3">
      <h5 class="fw-bold">Close Day</h5>
      <form method="post" action="<?= Router::url('/admin/day/close') ?>">
        <button class="btn btn-danger w-100">Close Day & Report</button>
      </form>
      <div class="muted small mt-2">Closing day is allowed for Reception/Manager (via login).</div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-3">
      <h5 class="fw-bold">Prices & Notification Settings (Today)</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead>
            <tr>
              <th>Employee</th>
              <th class="text-end">Shop</th>
              <th class="text-end">Employee</th>
              <th class="text-end">Notify (N)</th>
              <th class="text-end">Avg Min</th>
              <th class="text-end">Save</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($employees as $e): ?>
            <tr>
              <td class="fw-semibold"><?= Util::h($e['code'] . ' - ' . $e['name']) ?></td>
              <td class="text-end">
                <form method="post" class="d-flex justify-content-end gap-2">
                  <input type="hidden" name="action" value="save_prices">
                  <input type="hidden" name="employee_id" value="<?= (int)$e['id'] ?>">
                  <input class="form-control form-control-sm text-end" style="width:110px" name="shop_price" value="<?= Util::h((string)$e['shop_price']) ?>">
              </td>
              <td class="text-end">
                  <input class="form-control form-control-sm text-end" style="width:110px" name="employee_price" value="<?= Util::h((string)$e['employee_price']) ?>">
              </td>
              <td class="text-end">
                  <input class="form-control form-control-sm text-end" style="width:90px" name="notify_before_n" value="<?= (int)$e['notify_before_n'] ?>">
              </td>
              <td class="text-end">
                  <input class="form-control form-control-sm text-end" style="width:90px" name="avg_minutes" value="<?= (int)$e['avg_minutes'] ?>">
              </td>
              <td class="text-end">
                  <button class="btn btn-sm btn-outline-light">Save</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="muted small">Notify (N) sends a "before" message when remaining customers equals N. The "now" message is sent when ticket becomes serving.</div>
    </div>
  </div>
</div>

<?php if (!empty($printId)): ?>
<script>
  window.open("<?= Router::url('/print/ticket?id=' . (int)$printId) ?>", "_blank", "width=360,height=600");
</script>
<?php endif; ?>
